
		ORG		&a400
		write	direct	"a:SHAPECOD.BIN"
		;write		 "SHAPECOD.BIN"
MC_WAIT_FLYBACK EQU #BD19

		InitRSX:
		ld a,#c9
		ld (InitRSX),a 			; Ensure we don't try and initialise the RSX again - Bad Joo Joo 
		LD		HL,BufferRsx
		LD		BC,PtrRsx
		JP		#BCD1

PtrRsx:
		DW		RSX_Table
		JP		set_simple
		JP		set_double
		JP		set_window
		JP		set_tile
		JP		set_buffer
		JP		set_base


RSX_Table:
		DB		"SIMPL","E"+#80
		DB		"DOUBL","E"+#80
		DB		"WINDO","W"+#80
		DB		"FRAM","E"+#80
		DB		"BUFFE","R"+#80
		DB		"BAS","E"+#80						; Set Base Address of Sprite Memory
		DB		0

BufferRsx:
		DS		4                                   ; Mandatory for RSX Extension
BufferTemp:
		DS		4

base_adr:
		DW		0
unpack_adr:
		DW		0

set_simple:
ld a,8
ld (set_line+1),a
ld a,#c8
ld (add_with_carry+1),a
ret

set_double:
ld a,8*2
ld (set_line+1),a
ld a,#c8*2
ld (add_with_carry+1),a
ret

set_buffer:
		ld H,(ix+1)
		ld L,(ix+0)
		ld (unpack_adr),hl
		ret
		
		;
		;		Depack Window
		;
set_window:
        ; Calculate Offset Constant
 
		ld		a,(width+1)
		ld		h,a
		ld		a,(height+1)
		ld		e,a
		call	Mult8           ; HL = Result
        ld b,H
        ld c,L
        ld HL,0
        or A
        sbc hl,bc
        inc hl
        ld (InverseOffset),hl

        ; Start Unpack Code, Find the offset
		LD		HL,(base_adr)
		push	HL						; Preserve Base Address
		inc		HL
		inc		HL
		inc		HL						; Base Address + 3?
		ld		C,(IX+0)
		ld		B,(IX+1)  				; BC = frame number
		add		HL,BC
		add		HL,BC   				; (HL) = pointer to compressed frame
		ld		E,(HL)
		inc		HL
		ld		D,(HL)                  ; DE = Offset to Frame in Memory
        ex de,hl                        ; One Byte 4 T States saved
		pop		DE						
		add		HL,DE					; Add Base address to Byte Offset.

		LD		DE,(unpack_adr)
		CALL	DepkLzw                 ; Unpack Bytes to frame buffer

		ld B,(IX+2)				; Initial Y-Location
		ld C,(ix+4)				; Initial X-Location
		call	calcScrAddr		; Optimised Screen Calculation routine.
		ex de,hl 				; Saves On Byte and Four T-States ;) DE = Screen Address
		LD		HL,(unpack_adr)
		ld		a,(height+1)
		DB		#DD : LD      H,a	; LD IXH,A - undocumented op code
                                    ; Seems to hold height counter - Needs optimisation
;;        DI                          ; Disable Interrupts
;;        CALL MC_WAIT_FLYBACK        ; Wait Fly Back
DepkWin1:
		LD		A,(width+1)         ; A = Width
		LD		BC,(height+1)       ; C = Height, B should always be zero.
DepkWin2:
		LDI                         ; LD A,(HL); LD (DE),a; INC HL; INC DE; DEC BC
		ADD		HL,BC
		INC		C
		DEC		A
		JR		NZ,DepkWin2

        LD  BC,#f061
InverseOffset: EQU $-2

		ADD		HL,BC
		EX		DE,HL
		push		hl
		LD		hl,#800                 ; #800
		ld		a,(width+1)
		ld		c,a
		xor		a
		ld		b,a
		sbc		hl,bc
		LD		b,h
		ld		c,l
		pop		hl
		ADD		HL,BC
		JR		NC,DepkWin3
		LD		BC,#C050
		ADD		HL,BC
DepkWin3:
		EX		DE,HL
		DB		#DD : DEC     H
		JR		NZ,DepkWin1
;;        EI                             ; Enable Interrupts
		RET


set_tile:
;;        di
		LD		HL,(base_adr)
		push		HL
		inc		HL
		inc		HL
		inc		HL
		ld		C,(IX+0)
		ld		B,(IX+1)  ; BC = frame number
		add		HL,BC
		add		HL,BC   ; (HL) = pointer to compressed frame
		ld		E,(HL)
		inc		HL
		ld		D,(HL)
		ld		H,D
		ld		L,E   ; HL = pointer to compressed frame
		pop		DE
		add		HL,DE
Unpack:
		LD		DE,(unpack_adr) ;; to where
		CALL		depklzw

        call    MC_WAIT_FLYBACK
        call Drawshape
;;        EI
        ret


Drawshape:
		ld		iy,BufferTemp
		ld		DE,(unpack_adr) ;; DE = buffer (source)
		ld		A,(IX+2) ;; y-position
height:
		add		123  ;; self-modifying here, 123 is replaced by height
		nop			 ;; required since BC is loaded from Height+1 - must be better was as this requires 4 T-States
		ld		(IY+1),A  ;; (IY) = X position + height
		ld		A,(IX+4)  ;; y-position
width:
		add		123  ;; self-modifying here, 123 is replaced by width
		ld		(IY),A ;; (IY+1) = Y position + width
		ld		B,(IX+2) ;; Y
		ld		C,(IX+4) ;; X
		call calcScrAddr	; Get Base Screen Address - Most Intensive Call
        ld      a,(height+1)
        ld  c,a             ; Set Height Counter
set_loop01:
		push HL				; Preseve Screen Address
		ld a,(width+1)		; Get Width
		ld b,a				; Width Counter

set_loop02:
		ld		A,(DE)		; Read Data Buffer
		ld		(HL),A		; Write to Screen Address
;;push hl
;;push AF
;;ld A,H
;;sub &08
;;and &3F
;;or &C0
;;ld H,A
;;pop AF
;;ld		(HL),A
;;pop hl
		inc		HL			; Next Screen Byte
		inc		DE			; Next Data Byte
		djnz 	set_loop02	; More optimal Approach
		pop 	HL			; Restore Screen Address
		dec 	C			; Height Counter
		RET		z			; Quit if we're finished
		
		LD   a,h

set_line:
        ADD  a,8*2			; add #800
        JR   nc,scraddr2	; If No Carry in limits
        LD   a,l			; Add #50 to L
        ADD  a,#50
        LD   l,a
        LD   a,h
add_with_carry:
        ADC  a,#c8*2			; Add with Carry to set correct line
scraddr2:
        OR   #c0			; Force memory address in top 16KB
        LD   h,a			; Set H
		jr set_loop01		; Continue Looping

		;;		--------------------------------------------------------------------------------


calcScrAddr:				; Entry B=Row (0-199) , C=Column (0-79)
		push af
		push bc
		push de
		ld l,b
		ld h,c				; A fudge for now...
		LD		e,h
		LD		h,0
		LD		a,l
		AND		7    				; MOD to work out which row in screen memory to point to
		ADD		a,a
		ADD		a,a
		ADD		a,a   				; multiply by 8 (i.e. row * #800)
		LD		c,a   				; Store result in C for now...
		SRL		l    				; Divide Row by 8 to get the #50 offset
		SRL		l
		SRL		l
		LD		a,l   				; Get Row / 8 and Multiply by #50
		ADD		a,a   				; * 2
		ADD		a,a   				; * 4
		ADD		a,l   				; * 5
		ADD		a,a   				; * 10
		LD		l,a
		ADD		hl,hl
		ADD		hl,hl
		ADD		hl,hl   			; * 80
		LD		a,c   				; Finally add the sub row to h
		ADD		a,h
		LD		h,a
		LD		a,e
		ADD		a,l
		LD		l,a
		ADC		a,h
		SUB		l
		OR		#c0   				; ensure a valid screen address
		LD		h,a
		pop de
		pop bc
		pop af 
		RET


set_base:

		LD		L,(IX+0)
		LD		H,(IX+1)
		ld		(base_adr),HL
		ld		C,(HL)   ;; C = number of frames
		inc		HL
		ld		A,(HL)
		ld		(WIDTH+1),A
		inc		HL
		push		AF
		ld		A,(HL)
		ld		(HEIGHT+1),A
		ld		E,A
		pop		AF
		push		BC
		call		Multiply8BitUnsigned ; HL = size of frame in bytes
		pop		BC
		ld		DE,&A400
		ex		DE,HL   ; HL = &A400, DE = size in bytes
		scf
		ccf
		sbc		HL,DE   ; HL = &A400 - size in bytes
		ld		(unpack_adr),HL
		ret


		;
		;		Multiply two unsigned 8 Bit numbers
		;;		Entry: E = Number
		;		A = Number to Multiply By
		;;		Exit: HL = Result
		;		All Registers Dirty
		;
Multiply8BitUnsigned:
		LD		HL,0
		LD		D,L
		LD		B,8
M8ShiftL:
		ADD		HL,HL
		RLA
		JR		NC,M8Over
		ADD		HL,DE
M8Over:
		DJNZ		M8ShiftL
		RET

CodeLzw0F:
		LD		C,(HL)
		PUSH		HL
		LD		H,D
		LD		L,E
		CP		#F0
		JR		NZ,CodeLzw02
		;
		;		Length = Delta = InBuf[ InBytes + 1 ] + 1;
		;		InBytes += 2;
		;
		XOR		A
		LD		B,A
		INC		BC
		SBC		HL,BC
		LDIR
		POP		HL
		INC		HL
		JR		BclLzw
		;
CodeLzw02:
		CP		#20
		JR		C,CodeLzw01
		;
		;		Length = Delta = InBuf[ InBytes ];
		;
		LD		C,B
		LD		B,0
		SBC		HL,BC
		LDIR
		POP		HL
		JR		BclLzw

		;
		;		Length = Delta = 256;
		;
CodeLzw01:		; Here, B = 1
		XOR		A                       ; Carry to zero
		LD		C,A
		DEC		H
		LDIR
		POP		HL
		JR		BclLzw

		;
TstLzw10:
		RLCA		; A & 0x10 ?
		JR		NC,CodeLzw0F
		;
		;		Delta = ( InBuf[ InBytes++ ] & 15 ) << 8;
		;		Delta |= InBuf[ InBytes++ ];
		;		Longueur = InBuf[ InBytes++ ] + 1;
		;		Delta++;
		;
		RES		4,B                     ; B = Delta(high)
		LD		C,(HL)                  ; C = Delta(low)
		INC		HL
		LD		A,(HL)                  ; A = Length - 1
		PUSH		HL
		LD		H,D
		LD		L,E
		SBC		HL,BC                   ; Flag C=1 -> hl=hl-(bc+1)
		LD		B,0
		LD		C,A
		INC		BC                      ; BC = Length
		LDIR
		POP		HL
		INC		HL
		JR		BclLzw

		;
		;		Input :
		;		- HL = Buffer (compressed file)
		;		- DE = Destination
		;		Output :
		;		- AF, BC, DE, HL modified
		;
DepkLzw:
		LD		A,(HL)                  ; DepackBits = InBuf[ InBytes++ ]
		INC		HL
		RRA		; Fast rotation calculation only flag C
		SET		7,A                     ; Set bit 7 while keeping flag C
		LD		(BclLzw+1),A
		JR		C,TstCodeLzw
CopByteLzw:
		LDI		; OutBuf[ OutBytes++ ] = InBuf[ InBytes++ ]
		;
BclLzw:
		LD		A,0
		RR		A                       ; Rotation with calculation flags C and Z
		LD		(BclLzw+1),A
		JR		NC,CopByteLzw
		JR		Z,DepkLzw

TstCodeLzw:
		LD		A,(HL)                  ; A = InBuf[ InBytes ];
		AND		A
		RET		Z                       ; More bytes to process = finished

		INC		HL
		LD		B,A                     ; B = InBuf[ InBytes ]
		RLCA		; A & 0x80 ?
		JR		NC,TstLzw40
		;
		;		Length = 3 + ( ( InBuf[ InBytes ] >> 4 ) & 7 );
		;		Delta = ( InBuf[ InBytes++ ] & 15 ) << 8;
		;		Delta |= InBuf[ InBytes++ ];
		;		Delta++;
		;
		RLCA
		RLCA
		RLCA
		AND		7
		ADD		A,3
		LD		C,A                     ; C = Length
		LD		A,B                     ; B = InBuf[InBytes]
		AND		#0F
		LD		B,A                     ; B = Delta high
		LD		A,C                     ; A = Length
		LD		C,(HL)                  ; C = Delta low
		PUSH		HL
		LD		H,D
		LD		L,E
		SCF		; repositioning flag C
		SBC		HL,BC                   ; HL=HL-(BC+1)
		LD		B,0
		LD		C,A
		LDIR
		POP		HL
		INC		HL
		JR		BclLzw
		;
TstLzw40:
		RLCA		; A & 0x40 ?
		JR		NC,TstLzw20
		;
		;		Length = 2;
		;		Delta = InBuf[ InBytes++ ] & 0x3f;
		;		Delta++;
		;
		LD		C,B
		RES		6,C
		LD		B,0                     ; BC = Delta + 1 carry flag C = 1
		PUSH		HL
		LD		H,D
		LD		L,E
		SBC		HL,BC
		LDI
		LDI
		POP		HL
		JR		BclLzw
		;
TstLzw20:
		RLCA		; A & 0x20 ?
		JR		NC,TstLzw10
		;
		;		Length = 2 + ( InBuf[ InBytes++ ] & 31 );
		;		Delta = InBuf[ InBytes++ ];
		;		Delta++;
		;
		LD		A,B
		ADD		A,#E2                   ; = ( A AND #1F ) + 2, and carry position
		LD		C,(HL)                  ; C = Delta
		LD		B,0
		PUSH		HL
		LD		H,D
		LD		L,E
		SBC		HL,BC
		LD		C,A                     ; C = Length
		LDIR
		POP		HL
		INC		HL
		JR		BclLzw
		ret
		;
		;		Multiply 8-bit values
		;		In:  Multiply H with E
		;		Out: HL = result
		;
Mult8:
		ld		d,0
		ld		l,d
		ld		b,8
Mult8_Loop:
		add		hl,hl
		jr		nc,Mult8_NoAdd
		add		hl,de
Mult8_NoAdd:
		djnz		Mult8_Loop
		ret
endoffile:
